/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Single Point A/D
/* - Contents: α׷ COMI_AD_GetVolt(...)Լ Ͽ 
/*     Single point A/D ϴ α׷Դϴ.
/*
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define CHAN	 0
#define VMIN	-10 
#define VMAX	 10

void main (void)
{
	HANDLE hDevice;
	float ad_volt;

	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	COMI_AD_SetRange (hDevice, CHAN, VMIN, VMAX);
	printf("A/D ȯ Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();	
	while (!_kbhit())
	{
		ad_volt = COMI_AD_GetVolt (hDevice, CHAN);
		printf("A/D Result (volt) = %6.2f\n", ad_volt);
		Sleep(500);
	}
	
	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
